require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/chemistry.zip"),
	Asset("ANIM", "anim/build_chemistry.zip"),
	Asset("ATLAS", "images/inventoryimages/build_chemistry.xml"),
	
}

local prefabs =
{
    "collapse_small",
	"flint",
	"poop",
}
STRINGS.NAMES.CHEMISTRY = "化学台"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CHEMISTRY= "我可以在这里进行一些基础的化学实验"
STRINGS.NAMES.CHEMISTRYBUILD = "化学台建筑包"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CHEMISTRYBUILD= "把它设置在地上就可以了"
local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    local x, y, z = inst.Transform:GetWorldPosition()
    SpawnPrefab("goldnugget").Transform:SetPosition(x, y, z)
	SpawnPrefab("boards").Transform:SetPosition(x, y, z)
    
    inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", true)
end


local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
end
--分解系统
local function OnGetItemFromPlayer(inst, giver, item)
    if item.prefab == "condense_cutgrass" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("cutgrass")) end
    end
	--
    if item.prefab == "condense_goldnugget" 
	then 
	for k = 1, 20 do
giver.components.inventory:GiveItem( SpawnPrefab("goldnugget")) end
    end
	--
	    if item.prefab == "condense_rocks" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("rocks")) end
    end
	--
	    if item.prefab == "condense_twigs" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("twigs")) end
    end
	    if item.prefab == "condense_flint" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("flint")) end
    end
	    if item.prefab == "condense_nitre" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("nitre")) end
    end
	    if item.prefab == "wood" 
	then 
	for k = 1, 20 do
giver.components.inventory:GiveItem( SpawnPrefab("log")) end

    if item.prefab == "magicpower_mk2" 
	then 
	for k = 1, 40 do
giver.components.inventory:GiveItem( SpawnPrefab("magicpower")) end
    end
    end
end

local function OnRefuseItem(inst, giver, item)
    inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
    inst.AnimState:PlayAnimation("hit")
end
local function complete_doonact(inst)
    if inst._activecount > 1 then
        inst._activecount = inst._activecount - 1
    else
        inst._activecount = 0
        --inst.SoundEmitter:KillSound("sound")
    end

    --inst.SoundEmitter:PlaySound("dontstarve/common/researchmachine_lvl3_ding")
end
local function onactivate(inst)
    inst._activecount = inst._activecount + 1
    --if not inst.SoundEmitter:PlayingSound("sound") then
    --    inst.SoundEmitter:PlaySound("dontstarve/common/ancienttable_craft", "sound")
    --end

    inst:DoTaskInTime(1.5, complete_doonact)
end
--建筑包
local function build_fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("build_chemistry")
    inst.AnimState:SetBuild("build_chemistry")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("inspectable")
--分界线
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "build_chemistry"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/build_chemistry.xml"
    MakeHauntableLaunchAndSmash(inst)
	local function OnDeploy (inst, pt)
    SpawnPrefab("chemistryfx").Transform:SetPosition(pt.x, pt.y, pt.z)
    inst:Remove()
end
	inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy

    return inst
end
--特效
local function fn_spear()
	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)

    --inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("build_chemistry")
    inst.AnimState:SetBuild("build_chemistry")
    inst.AnimState:PlayAnimation("fx")

    inst:AddTag("fx")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false

    inst:AddComponent("combat")
	--生命周期
	inst.lifetime = 1.1
	local chest = SpawnPrefab("chemistry")
	
	inst:DoTaskInTime(inst.lifetime, function()
		if inst then
		local x, y, z = inst.Transform:GetWorldPosition()
		chest.Transform:SetPosition(x, y, z)
		inst:Remove()
			
		end
	end)

	return inst
end
--化学台
local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst,.6)
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 2,2 )
    inst.AnimState:SetBank("chemistry")
    inst.AnimState:SetBuild("chemistry")
    inst.AnimState:PlayAnimation("idle")
    MakeSnowCoveredPristine(inst)
    inst:AddTag("structure")
    inst:AddTag("sign")
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	inst._activecount = 0
	--分解
     inst:AddComponent("trader")
	 inst.components.trader:SetAcceptTest(function(inst,item)
	 if item.prefab == "condense_rocks" or item.prefab == "condense_goldnugget" or item.prefab == "condense_flint" or item.prefab == "condense_cutgrass"  or item.prefab == "condense_twigs"  or item.prefab == "condense_nitre" or item.prefab == "wood" or item.prefab == "magicpower_mk2"  
	 then
	 return true
	 end
	 return false
	 end)
	 inst.components.trader.onaccept = OnGetItemFromPlayer
	
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(5)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    inst:AddComponent("inspectable")
	inst:AddComponent("prototyper")
    inst.components.prototyper.onactivate = onactivate
	inst.components.prototyper.trees = TUNING.PROTOTYPER_TREES.TOU_ASTITEM_TWO
    inst:AddComponent("lootdropper")
	   inst:ListenForEvent("onbuilt", onbuilt)
	   MakeHauntableWork(inst)
    return inst
end
return Prefab("chemistry", fn, assets, prefabs),
Prefab("chemistrybuild", build_fn, assets, prefabs),
Prefab("chemistryfx", fn_spear, assets, prefabs),
MakePlacer("chemistrybuild_placer", "chemistry", "chemistry", "idle")
